/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.security.util.KnownOIDs;

final class PolicyNodeImpl
implements PolicyNode {
    private static final String ANY_POLICY = KnownOIDs.CE_CERT_POLICIES_ANY.value();
    private PolicyNodeImpl mParent;
    private HashSet<PolicyNodeImpl> mChildren;
    private String mValidPolicy;
    private HashSet<PolicyQualifierInfo> mQualifierSet;
    private boolean mCriticalityIndicator;
    private HashSet<String> mExpectedPolicySet;
    private boolean mOriginalExpectedPolicySet;
    private int mDepth;
    private boolean isImmutable = false;

    PolicyNodeImpl(PolicyNodeImpl policyNodeImpl, String string, Set<PolicyQualifierInfo> set, boolean bl, Set<String> set2, boolean bl2) {
        this.mParent = policyNodeImpl;
        this.mChildren = new HashSet();
        this.mValidPolicy = string != null ? string : "";
        this.mQualifierSet = set != null ? new HashSet<PolicyQualifierInfo>(set) : new HashSet();
        this.mCriticalityIndicator = bl;
        this.mExpectedPolicySet = set2 != null ? new HashSet<String>(set2) : new HashSet();
        boolean bl3 = this.mOriginalExpectedPolicySet = !bl2;
        if (this.mParent != null) {
            this.mDepth = this.mParent.getDepth() + 1;
            this.mParent.addChild(this);
        } else {
            this.mDepth = 0;
        }
    }

    PolicyNodeImpl(PolicyNodeImpl policyNodeImpl, PolicyNodeImpl policyNodeImpl2) {
        this(policyNodeImpl, policyNodeImpl2.mValidPolicy, policyNodeImpl2.mQualifierSet, policyNodeImpl2.mCriticalityIndicator, policyNodeImpl2.mExpectedPolicySet, false);
    }

    @Override
    public PolicyNode getParent() {
        return this.mParent;
    }

    public Iterator<PolicyNodeImpl> getChildren() {
        return Collections.unmodifiableSet(this.mChildren).iterator();
    }

    @Override
    public int getDepth() {
        return this.mDepth;
    }

    @Override
    public String getValidPolicy() {
        return this.mValidPolicy;
    }

    public Set<PolicyQualifierInfo> getPolicyQualifiers() {
        return Collections.unmodifiableSet(this.mQualifierSet);
    }

    @Override
    public Set<String> getExpectedPolicies() {
        return Collections.unmodifiableSet(this.mExpectedPolicySet);
    }

    @Override
    public boolean isCritical() {
        return this.mCriticalityIndicator;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.asString());
        for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
            stringBuilder.append(policyNodeImpl);
        }
        return stringBuilder.toString();
    }

    boolean isImmutable() {
        return this.isImmutable;
    }

    void setImmutable() {
        if (this.isImmutable) {
            return;
        }
        for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
            policyNodeImpl.setImmutable();
        }
        this.isImmutable = true;
    }

    private void addChild(PolicyNodeImpl policyNodeImpl) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        this.mChildren.add(policyNodeImpl);
    }

    void addExpectedPolicy(String string) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        if (this.mOriginalExpectedPolicySet) {
            this.mExpectedPolicySet.clear();
            this.mOriginalExpectedPolicySet = false;
        }
        this.mExpectedPolicySet.add(string);
    }

    void prune(int n) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        if (this.mChildren.size() == 0) {
            return;
        }
        Iterator<PolicyNodeImpl> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl = iterator.next();
            policyNodeImpl.prune(n);
            if (policyNodeImpl.mChildren.size() != 0 || n <= this.mDepth + 1) continue;
            iterator.remove();
        }
    }

    void deleteChild(PolicyNode policyNode) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        this.mChildren.remove(policyNode);
    }

    PolicyNodeImpl copyTree() {
        return this.copyTree(null);
    }

    private PolicyNodeImpl copyTree(PolicyNodeImpl policyNodeImpl) {
        PolicyNodeImpl policyNodeImpl2 = new PolicyNodeImpl(policyNodeImpl, this);
        for (PolicyNodeImpl policyNodeImpl3 : this.mChildren) {
            policyNodeImpl3.copyTree(policyNodeImpl2);
        }
        return policyNodeImpl2;
    }

    Set<PolicyNodeImpl> getPolicyNodes(int n) {
        HashSet<PolicyNodeImpl> hashSet = new HashSet<PolicyNodeImpl>();
        this.getPolicyNodes(n, hashSet);
        return hashSet;
    }

    private void getPolicyNodes(int n, Set<PolicyNodeImpl> set) {
        if (this.mDepth == n) {
            set.add(this);
        } else {
            for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
                policyNodeImpl.getPolicyNodes(n, set);
            }
        }
    }

    Set<PolicyNodeImpl> getPolicyNodesExpected(int n, String string, boolean bl) {
        if (string.equals(ANY_POLICY)) {
            return this.getPolicyNodes(n);
        }
        return this.getPolicyNodesExpectedHelper(n, string, bl);
    }

    private Set<PolicyNodeImpl> getPolicyNodesExpectedHelper(int n, String string, boolean bl) {
        HashSet<PolicyNodeImpl> hashSet = new HashSet<PolicyNodeImpl>();
        if (this.mDepth < n) {
            for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
                hashSet.addAll(policyNodeImpl.getPolicyNodesExpectedHelper(n, string, bl));
            }
        } else if (bl) {
            if (this.mExpectedPolicySet.contains(ANY_POLICY)) {
                hashSet.add(this);
            }
        } else if (this.mExpectedPolicySet.contains(string)) {
            hashSet.add(this);
        }
        return hashSet;
    }

    Set<PolicyNodeImpl> getPolicyNodesValid(int n, String string) {
        HashSet<PolicyNodeImpl> hashSet = new HashSet<PolicyNodeImpl>();
        if (this.mDepth < n) {
            for (PolicyNodeImpl policyNodeImpl : this.mChildren) {
                hashSet.addAll(policyNodeImpl.getPolicyNodesValid(n, string));
            }
        } else if (this.mValidPolicy.equals(string)) {
            hashSet.add(this);
        }
        return hashSet;
    }

    private static String policyToString(String string) {
        if (string.equals(ANY_POLICY)) {
            return "anyPolicy";
        }
        return string;
    }

    String asString() {
        if (this.mParent == null) {
            return "anyPolicy  ROOT\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getDepth();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        stringBuilder.append(PolicyNodeImpl.policyToString(this.getValidPolicy()));
        stringBuilder.append("  CRIT: ");
        stringBuilder.append(this.isCritical());
        stringBuilder.append("  EP: ");
        for (String string : this.getExpectedPolicies()) {
            stringBuilder.append(PolicyNodeImpl.policyToString(string));
            stringBuilder.append(" ");
        }
        stringBuilder.append(" (");
        stringBuilder.append(this.getDepth());
        stringBuilder.append(")\n");
        return stringBuilder.toString();
    }
}

